#include "DDialogoModal.h"

namespace DWL {
            
	//! Destructor  
    /*! Destructor por defecto.
		    \fn		   ~DDialogoModal(void);
            \return     No devuelve nada
    */
    DDialogoModal::~DDialogoModal(void) { 
        Destruir();
	};
 
    //! Funcin que crea el dialogo.
    /*!	Esta funcin crea el dialogo.
	        \fn			void Crear(int ID_Dialogo, const int cX, const int cY, DBaseWnd *nPadre);
	        \param[in]	ID_Dialogo	    ID del dialogo en los recursos.
            \param[in]	nPadre    	    Clase DBaseWnd que hace de padre (NULL en caso de ser un dialogo padre)
	        \return		Devuelve el HWND del dialogo. En caso de error devolver NULL.
    */
    void DDialogoModal::Crear(int ID_Dialogo, DBaseWnd *nPadre) {
		if (_hWnd != NULL) Destruir();

        _AgregarAppBaseWnd(0, nPadre);

        HWND hWndPadre = NULL;
        if (nPadre != NULL) hWndPadre = nPadre->hWnd();

        DialogBoxParam(GetModuleHandle(NULL), MAKEINTRESOURCE(ID_Dialogo), hWndPadre, (DLGPROC)_GestorMensajes, (LPARAM)this);
//		else               _hWnd = CreateDialogParam(GetModuleHandle(NULL), MAKEINTRESOURCE(ID_Dialogo), hWndPadre, (DLGPROC)_GestorMensajes, (LPARAM)this); 
/*		RECT RC; 
		GetWindowRect(_hWnd, &RC); 	
		int NX = cX; 
		int NY = cY; 	
//		if (cX == DWL_CENTRADO) NX = _CalcularCentrado(NULL, true, RC.right); 
//		if (cY == DWL_CENTRADO) NY = _CalcularCentrado(NULL, false, RC.bottom);
		Mover(NX, NY, RC.right, RC.bottom); 
		return _hWnd;*/
	};


	//! Funcin que destruye esta ventana / control.
	/*!	Esta funcion destruye esta ventana / control.
			\fn			virtual BOOL Destruir(void);
			\return		Devuelve TRUE si la operacin se completo, FALSE en caso contrario.
	*/
    BOOL DDialogoModal::Destruir(void) {
		if (_hWnd == NULL) return TRUE;
        INT_PTR Resultado = 0;
        EndDialog(_hWnd, Resultado);
		_hWnd = NULL;
		return TRUE;
	};


    //! Funcin virtual para determinar si la ventana es maximizable.
    /*! Esta funcin virtual determina si la ventana es maximizable.
		    \fn			virtual void Maximizable(const bool nMax);
		    \param[in]	nMax : Especifica true para que la ventana sea maximizable, false para lo contrario.
		    \return		Esta funcin no devuelve nada.
    */
    void DDialogoModal::Maximizable(const bool nMax) { 
		LONG_PTR Estilos = GetWindowLongPtr(_hWnd, GWL_STYLE); 
		if (Estilos & WS_MAXIMIZEBOX)	Estilos = Estilos & ~ WS_MAXIMIZEBOX;  
		if (nMax == true)				Estilos = Estilos | WS_MAXIMIZEBOX;
		SetWindowLongPtr(_hWnd, GWL_STYLE, Estilos); 
	};

    //! Funcin virtual que nos dice si la ventana es maximizable.
    /*! Esta funcin virtual nos dice si la ventana es maximizable.
		    \fn			virtual const bool Maximizable(void);
		    \return		Devuelve true si la ventana es maximizable, false en caso contrario.
    */
    const bool DDialogoModal::Maximizable(void) {
		LONG_PTR Estilos = GetWindowLongPtr(_hWnd, GWL_STYLE); 
		if (Estilos & WS_MAXIMIZEBOX) return true; 
		else                          return false;
	};

    //! Funcin que nos dice si la ventana esta maximizada en este momento.
    /*! Esta funcin nos dice si la ventana esta maximizada en este momento.
		    \fn			const bool Maximizada(void);
		    \return		Devuelve true si la ventana esta maximizada, false en caso contrario.
    */
    const bool DDialogoModal::Maximizada(void) {
		WINDOWPLACEMENT WndPl;
		GetWindowPlacement(_hWnd, &WndPl);
		if (WndPl.showCmd == SW_MAXIMIZE) return true;
		return false;
	};

    //! Funcin virtual para determinar si la ventana es minimizable.
    /*! Esta funcin virtual determina si la ventana es minimizable.
		    \fn			virtual void Minimizable(const bool nMin);
		    \param[in]	nMix : Especifica true para que la ventana sea minimizable, false para lo contrario.
		    \return		Esta funcin no devuelve nada.
    */
    void DDialogoModal::Minimizable(const bool nMin) { 
		LONG_PTR Estilos = GetWindowLongPtr(_hWnd, GWL_STYLE);
		if (Estilos & WS_MINIMIZEBOX)	Estilos = Estilos & ~ WS_MINIMIZEBOX; 
		if (nMin == true)				Estilos = Estilos | WS_MINIMIZEBOX; 
		SetWindowLongPtr(_hWnd, GWL_STYLE, Estilos); 
	};

    //! Funcin virtual que nos dice si la ventana es minimizable.
    /*! Esta funcin virtual nos dice si la ventana es minimizable.
		    \fn			virtual const bool Minimizable(void);
		    \return		Devuelve true si la ventana es minimizable, false en caso contrario.
    */
    const bool DDialogoModal::Minimizable(void) { 
		LONG_PTR Estilos = GetWindowLongPtr(_hWnd, GWL_STYLE); 
		if (Estilos & WS_MINIMIZEBOX) return true; 
		else						  return false;
	};

    //! Funcin que nos dice si la ventana esta minimizada en este momento.
    /*! Esta funcin nos dice si la ventana esta minimizada en este momento.
		    \fn			const bool Minimizada(void);
		    \return		Devuelve true si la ventana esta minimizada, false en caso contrario.
    */
    const bool DDialogoModal::Minimizada(void) {
		WINDOWPLACEMENT WndPl;
		GetWindowPlacement(_hWnd, &WndPl);
		if (WndPl.showCmd == SW_MINIMIZE) return true;
		return false;
	};

    //! Funcin para posicionar la ventana siempre delante de todas las otras ventanas.
    /*! Esta funcin posiciona la ventana siempre delante de todas las otras ventanas.
		    \fn			virtual void SiempreDelante(const bool SD);
		    \param[in]	SD : Especifica true para que la ventana quede siempre por delante, false para que tenga un comportamiento normal segun su coordenada Z.
		    \return		Esta funcin no devuelve nada.
            \remarks    Por norma las ventanas se posicionan utilizando el OrdenZ, que es un indice para determinar en que posicin estan las ventanas. 
                        Si por ejemplo creas dos ventanas la primera se pondra en el orden 1, y la segunda en el orden 0, 
                        de forma que si se crean en cascada deberias ver la segunda ventana por delante de todo.
    */
    void DDialogoModal::SiempreDelante(const bool SD) {
        SetWindowPos(_hWnd, (SD ? HWND_TOPMOST : HWND_TOP), 0, 0, 0, 0, SWP_NOSIZE | SWP_NOMOVE); // NTY
//        if (SD == true) SetWindowPos(_hWnd, HWND_TOPMOST, 0, 0, 0, 0, SWP_NOSIZE | SWP_NOMOVE); // NTY
//		else			SetWindowPos(_hWnd, HWND_TOP, 0, 0, 0, 0, SWP_NOSIZE | SWP_NOMOVE);		// NTY
	};

    //! Funcin para asignar el titulo de la ventana.
    /*! Esta funcin asigna el titulo de la ventana.
		    \fn			void Titulo(const TCHAR *Txt);
		    \param[in]	Txt : Nuevo texto para el titulo de la ventana.
		    \return		Esta funcin no devuelve nada.
    */
    void DDialogoModal::Titulo(const TCHAR *Txt) {
		SetWindowText(_hWnd, Txt);
	};

    //! Funcin para obtener el titulo de la ventana.
    /*! Esta funcin obtiene el titulo de la ventana en el buffer especificado.
		    \fn			void Titulo(const TCHAR *Txt);
		    \param[in]	Txt    : Buffer de texto para obtener el titulo.
            \param[in]  TamTxt : Tamao del buffer para el titulo.
		    \return		Esta funcin devuelve 0 en caso de error. En caso de exito devuelve el numero de caracteres que contiene el titulo sin incluir el terminador NULL.
    */
    int DDialogoModal::Titulo(TCHAR *Txt, const int TamTxt) { 
		return GetWindowText(_hWnd, Txt, TamTxt);
	};


	//! Esqueleto inicial que enlaza esta clase con la ventana.
	/*! Esta funcin es el esqueleto inicial que enlaza esta clase con la ventana.
			\fn			static INT_PTR CALLBACK _GestorMensajes(HWND hWndDialogo, UINT uMsg, WPARAM wParam, LPARAM lParam);
			\param[in]	HandleVentana	: Identificador de ventana.
			\param[in]	uMsg			: Mensaje.
			\param[in]	wParam			: Parametro1.
			\param[in]	lParam			: Parametro2.
			\return		Dependiendo del mensaje y los parametros devuelve una cosa o otra.
	*/
    INT_PTR CALLBACK DDialogoModal::_GestorMensajes(HWND hWndDialogo, UINT uMsg, WPARAM wParam, LPARAM lParam) {
		switch (uMsg) {
			case WM_INITDIALOG : {
				DDialogoModal *PreDialogo = reinterpret_cast<DDialogoModal *>(lParam);
//                SetWindowTheme(hWndDialogo, TEXT("Explorer"), NULL);
				PreDialogo->_hWnd = hWndDialogo;
				SetWindowLongPtr(hWndDialogo, GWLP_USERDATA, (long)lParam);
				PreDialogo->GestorMensajes(uMsg, wParam, lParam);
				return TRUE;
			}

            // CUSTOM DRAW (ListView y TreeView)
            case WM_NOTIFY : // OJO WM_NOTIFY debe ir encima de default: no le pongo un break porque solo quiero saber si es un CUSTOMDRAW, en caso contrario se debe tratar como un mensaje normal
                if (((LPNMHDR)lParam)->code == NM_CUSTOMDRAW)
                    return SendMessage(((LPNMHDR)lParam)->hwndFrom, DWL_CUSTOM_DRAWDLG, wParam, lParam);
			default : {
				DDialogoModal *Dialogo = reinterpret_cast<DDialogoModal *>(GetWindowLongPtr(hWndDialogo, GWLP_USERDATA));
				if (Dialogo == NULL) return FALSE;
//                    if (Dialogo == NULL) return DefDlgProc(HandleDialogo, uMsg, wParam, lParam);
                INT_PTR Ret = Dialogo->GestorMensajes(uMsg, wParam, lParam);
                if (Ret == DWL_USAR_GESTOR_POR_DEFECTO) return FALSE;
//                    if (Ret == DWL_USAR_GESTOR_POR_DEFECTO) return DefDlgProc(HandleDialogo, uMsg, wParam, lParam);
                return Ret;
			}
		}
	};


};
